<?php
// Set up vars to track results.
$errorMessages = '';
$taxRate = 0;
$stateShortName = '';
$stateLongName = '';
$price = 0;
$tax = 0;
$total = 0;
// State validation.
$stateErrorMessage = '';
// Is there input?
if (!isset($_GET['state'])) {
    $stateErrorMessage = 'Sorry, you must give a state.<br>';
}
if ($stateErrorMessage == '') {
    // There is a state.
    $stateShortName = strtoupper(trim($_GET['state']));
    // Is the state known?
    if ($stateShortName != 'MI' && $stateShortName != 'IL') {
        $stateErrorMessage = "Sorry, '$stateShortName' is not a recognized state.<br>";
    }
}
// Price validation.
$priceErrorMessage = '';
// Value given?
if (!isset($_GET['price'])) {
    $priceErrorMessage = 'Sorry, you must give a price.<br>';
}
// Numeric check.
if ($priceErrorMessage == '') {
    // Get the price.
    $price = $_GET['price'];
    // Check that price is numeric.
    if (!is_numeric($price)) {
        $priceErrorMessage = 'Sorry, price must be a number.<br>';
    }
}
// Range check.
if ($priceErrorMessage == '') {
    if ($price <= 0) {
        $priceErrorMessage = 'Sorry, price must be more than zero.<br>';
    }
    if ($price >= 1000000) {
        $priceErrorMessage = 'Sorry, price is too high to be real.<br>';
    }
}
// Combine the error messages.
$errorMessages = $stateErrorMessage . $priceErrorMessage;
// Should there be processing?
if ($errorMessages == '') {
    // No input errors.
    if ($stateShortName == 'MI') {
        $stateLongName = 'Michigan';
        $taxRate = 0.06;
    }
    else {
        $stateLongName = 'Illinois';
        $taxRate = 0.0625;
    }
    $tax = $price * $taxRate;
    $total = $price + $tax;
}
?><!doctype html>
<html lang="en">
    <head>
        <title>Sales tax</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <link rel="stylesheet" href="styles.css">
    </head>
    <body>
        <h1>Sales tax</h1>
        <?php
        if ($errorMessages != '') {
            print "<div class='error-message'>
                     <p>There were errors.</p>
                     <p>$errorMessages</p>
                   </div>\n";
        }
        else {
            print "<p>Price: $price</p>
                   <p>Sales tax ($stateLongName, $taxRate): $tax</p>
                   <p>Total: $total</p>\n";
        }
        ?>
    </body>
</html>
